#include <bits/stdc++.h>
using namespace std;

struct node
{
    int money;
    long long sum = 0;
    vector <int> links;
};

node banks[200001];

void spread (node& bank, int current, int depth, int prev, int initial_cash_money)
{
    depth++;
    bank.sum += initial_cash_money*depth;
    for (int j=0; j<bank.links.size(); j++)
    {
        int next = bank.links[j];
        if (next!=prev)
            spread( banks[next], next, depth, current, initial_cash_money);
    }
}
int get_best (int n)
{
    int best_bank, min = INT_MAX;
    for (int i=1; i<=n; i++)
    {
        if (banks[i].sum<min)
        {
            min = banks[i].sum ;
            best_bank = i;
        }
        banks[i].sum = 0;
    }
    return best_bank;
}
int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n, q;

    cin >>n;
    for (int i=1; i<n; i++)
    {
        int x, y;
        cin >> x >> y;
        banks[x].links.push_back(y);
        banks[y].links.push_back(x);
    }
    for (int i=1; i<=n; i++)
    {
        int x;
        cin >> x;
        banks[i].money = x;
    }
    for (int i=1; i<=n; i++)
    {
        spread(banks[i], i, -1, -1, banks[i].money);
    }
    cout << get_best(n) << "\n";
    // upiti
    cin >> q;
    for (int i=0; i<q; i++)
    {
        int z, b;
        cin >> z >> b;
        banks[b].money += z;
        for (int i=1; i<=n; i++)
        {
            spread(banks[i], i, -1, -1, banks[i].money);
        }
        cout << get_best(n) << "\n";
    }
    return 0;
}